
function path = simmarkovgiveinit(Q,T,start)

%%%
%%% simulation of Markov Chain with transition Q, for T period ; initial
%%% condition assigned by start
%%% 

S = size(Q,1) ;

if size(Q,2)~=S
    disp('Q is not a square matrix');
end

path = zeros(T,1) ;

path(1) = start ; 

U = rand(T-1,1) ;

for t=1:T-1
    [crap,path(t+1)] =  max( (cumsum(Q(path(t),:))-U(t)>0) ) ;
end

    
    